//
//  MCXMLBuilder.h
//  MCHTTPServer
//
//  Created by Alykhan Jetha on 09-09-01.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import "MCMLBuilder.h"

@interface MCXMLBuilder : MCMLBuilder {
	NSXMLDocument *xmldoc;
	NSXMLElement *root;
	NSXMLElement *currentNode;
	
}

@property (readonly, retain) NSXMLElement *root;
@property (readonly, retain) NSXMLElement *currentNode;
@property (readonly, retain) NSXMLDocument *xmldoc;

- (MCXMLBuilder *)initWithRootName:(NSString *)name;


/*!
 Used for creating nestable blocks. For example the header or site nagivation or a commonly used div. The passed in builder will be rendered useless after the take as the root will be moved to the receiver. As a convenience, you can use call -copy to get a retained duplicate.
 */
+ (MCXMLBuilder *)XMLBuilderWithRootName:(NSString *)name attributes:(NSDictionary *)attribs;
- (MCXMLBuilder *)initWithRootName:(NSString *)name attributes:(NSDictionary *)attribs;



@end
